/*
 * Decompiled with CFR 0.152.
 */
package jclass.datasource.vcafe25;

import java.beans.Beans;
import java.beans.VetoableChangeSupport;
import java.util.StringTokenizer;
import jclass.datasource.DataModel;
import jclass.datasource.DataModelException;
import jclass.datasource.DataModelListener;
import jclass.datasource.DataTableModel;
import jclass.datasource.IdeDataTableModel;
import jclass.datasource.IdeMetaData;
import jclass.datasource.LocaleBundle;
import jclass.datasource.MetaDataModel;
import jclass.datasource.treemodel.TreeNode;
import jclass.datasource.vcafe25.Column;
import jclass.datasource.vcafe25.DataTable;
import symantec.itools.db.beans.binding.ExceptionEvent;
import symantec.itools.db.beans.binding.ExceptionEventListener;
import symantec.itools.db.beans.binding.Mediator;
import symantec.itools.db.beans.binding.QueryNavigator;
import symantec.itools.db.beans.binding.TriggerUIEvent;
import symantec.itools.db.beans.binding.TriggerUIListener;
import symantec.itools.db.beans.jdbc.ColumnMetaData;
import symantec.itools.db.beans.jdbc.RecordDefinition;

public class MetaData
extends IdeMetaData
implements TriggerUIListener,
ExceptionEventListener {
    static final long serialVersionUID = 1218065800951392308L;
    Exception eventException;
    QueryNavigator dataSet;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private boolean isRoot = false;
    private static final int NOT_FOUND = -1;
    private Mediator mediator;
    private String[] getMethods = new String[]{"getjdbcDataSource()"};
    private String[] setMethods = new String[]{"setjdbcDataSource(Value)"};
    private String dataBinding = "";

    public MetaData(DataModel dataModel, Object object) throws DataModelException {
        super(dataModel);
        try {
            this.isRoot = true;
            dataModel.getMetaDataTree().setRoot(this);
            this.init(object);
            dataModel.getDataTableTree().setRoot(new DataTable((MetaDataModel)this, (QueryNavigator)object));
            return;
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    public MetaData(DataModel dataModel, MetaDataModel metaDataModel, Object object) throws DataModelException {
        super(dataModel);
        try {
            dataModel.getMetaDataTree().append((TreeNode)((Object)metaDataModel), this);
            this.init(object);
            return;
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    public MetaData(DataModel dataModel) throws DataModelException {
        super(dataModel);
        try {
            this.isRoot = true;
            dataModel.getMetaDataTree().setRoot(this);
            return;
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    public MetaData(DataModel dataModel, TreeNode treeNode) throws DataModelException {
        super(dataModel);
        try {
            dataModel.getMetaDataTree().append(treeNode, this);
            return;
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    private void init(Object object) throws Exception {
        this.dataSet = (QueryNavigator)object;
        if (!this.dataSet.getAutoStart()) {
            String string = LocaleBundle.string("QueryNavigator.setAutoStart(true) must be called before creating this MetaData.");
            throw new Exception(string);
        }
        this.createColumnObjects();
        this.dataSet.addTriggerUIListener((TriggerUIListener)this);
        this.dataSet.addExceptionEventListener((ExceptionEventListener)this);
    }

    private void createColumnObjects() throws Exception {
        this.clear();
        RecordDefinition recordDefinition = (RecordDefinition)this.dataSet.getCurrentObject();
        int n = recordDefinition.getDataModel().getMemberCount();
        int n2 = 0;
        while (n2 < n) {
            ColumnMetaData columnMetaData = (ColumnMetaData)recordDefinition.getDataModel().getMemberModel(n2);
            Column column = new Column(columnMetaData);
            this.addColumn(column);
            ++n2;
        }
    }

    private void createColumnObjects(String string) throws Exception {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@,");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2 == null || !string2.toLowerCase().equals("all")) continue;
            this.createColumnObjects();
            return;
        }
        this.clear();
        string2 = (RecordDefinition)this.dataSet.getCurrentObject();
        string2.getDataModel().getMemberCount();
        String string3 = string.substring(string.indexOf("@") + 1, string.length());
        if (string3.indexOf("%") > -1) {
            string3 = string3.substring(0, string3.indexOf("%"));
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "@,");
        while (stringTokenizer2.hasMoreTokens()) {
            String string4 = stringTokenizer2.nextToken();
            int n = this.getIdeColumnIndexFromName(string4);
            if (n == -1) continue;
            ColumnMetaData columnMetaData = (ColumnMetaData)string2.getDataModel().getMemberModel(n);
            Column column = new Column(columnMetaData);
            this.addColumn(column);
        }
    }

    int getIdeColumnIndexFromName(String string) {
        RecordDefinition recordDefinition = (RecordDefinition)this.dataSet.getCurrentObject();
        if (recordDefinition == null) {
            return -1;
        }
        int n = recordDefinition.getDataModel().getMemberCount();
        int n2 = 0;
        if (string != null) {
            while (n2 < n) {
                if (string.equals(recordDefinition.getDataModel().getMemberModel(n2).getName())) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public Object getNativeMetaData() {
        return this.dataSet;
    }

    public void commitUI(TriggerUIEvent triggerUIEvent) {
        if (!this.getDataModel().getEventsEnabled()) {
            return;
        }
        IdeDataTableModel ideDataTableModel = (IdeDataTableModel)this.getCurrentDataTable();
        if (ideDataTableModel == null || triggerUIEvent.m_Row == -1) {
            return;
        }
        switch (triggerUIEvent.m_Type) {
            case 1: {
                this.undoDependantMove(ideDataTableModel);
                return;
            }
            case 2: {
                try {
                    if (ideDataTableModel.getRowStatus(ideDataTableModel.getBookmarkFromIdeIndex(triggerUIEvent.m_Row)) == 2) {
                        return;
                    }
                    if (this.dataSet.isDirty()) {
                        this.turnOffDataModelEvents();
                        this.dataSet.saveAll(2);
                        this.turnOnDataModelEvents();
                        this.requeryCurrentRowAndBelow((DataModelListener)((Object)ideDataTableModel), ideDataTableModel);
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
                this.navigated(triggerUIEvent.m_Row);
                return;
            }
            case 3: {
                try {
                    this.turnOffDataModelEvents();
                    this.dataSet.saveAll(1);
                    this.dataSet.restart();
                    this.turnOnDataModelEvents();
                }
                catch (Exception exception) {
                    this.eventException = exception;
                }
                this.requeryCurrentRowAndBelow((DataModelListener)((Object)ideDataTableModel), this.getCurrentDataTable());
                return;
            }
            case 4: {
                try {
                    ideDataTableModel.addRow2(triggerUIEvent.m_Row);
                    return;
                }
                catch (Exception exception) {
                    this.eventException = exception;
                    return;
                }
            }
            case 6: {
                this.handleIDERecordChanged((DataTable)ideDataTableModel, triggerUIEvent.m_Row);
                return;
            }
        }
    }

    void undoDependantMove(IdeDataTableModel ideDataTableModel) {
        try {
            if (this.handledAsSingleLevelBindingMove()) {
                return;
            }
            this.getDataModel().moveToRow((DataModelListener)((Object)ideDataTableModel), IdeMetaData.globalDataTableBeforeLastMove, IdeMetaData.globalBookmarkBeforeLastMove);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return;
        }
    }

    private void handleIDERecordChanged(DataTable dataTable, int n) {
        long l = dataTable.getBookmarkFromIdeIndex(n);
        System.out.println(l);
        switch (dataTable.getRowStatus(l)) {
            case 2: {
                try {
                    if (this.dataSet.getRowState().equals("Existing row") || !this.dataSet.isDirty()) {
                        dataTable.removeRowFromInsertedTable(l);
                        dataTable.removeRowFromUpdatedTable(l);
                        try {
                            this.turnOffDataModelEvents();
                            this.dataSet.restart();
                            this.turnOnDataModelEvents();
                        }
                        catch (Exception exception) {
                            System.out.println(exception.toString());
                        }
                        this.requeryCurrentRowAndBelow(dataTable, dataTable);
                        return;
                    }
                    this.handleIDEUpdateCellRequest(n);
                    return;
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                    return;
                }
            }
            case 1: {
                try {
                    if (this.dataSet.getRowState().equals("Existing row")) {
                        this.turnOffDataModelEvents();
                        this.dataSet.saveAll(2);
                        this.dataSet.restart();
                        this.turnOnDataModelEvents();
                        this.requeryCurrentRowAndBelow(dataTable, dataTable);
                        return;
                    }
                    this.handleIDEUpdateCellRequest(n);
                    return;
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                    return;
                }
            }
            case 4: {
                try {
                    this.handleIDEUpdateCellRequest(n);
                    return;
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                    return;
                }
            }
        }
    }

    private void handleIDEUpdateCellRequest(int n) {
        DataTableModel dataTableModel = this.getCurrentDataTable();
        if (dataTableModel == null) {
            return;
        }
        long l = -1L;
        try {
            l = ((DataTable)dataTableModel).getBookmarkFromIdeIndex(n);
        }
        catch (Exception exception) {
            return;
        }
        if (!this.dataSet.isDirty()) {
            ((DataTable)dataTableModel).commitRow2(l);
            return;
        }
        super.handleIDEUpdateCellRequest((IdeDataTableModel)dataTableModel, l);
    }

    public QueryNavigator getjdbcDataSource() {
        return this.dataSet;
    }

    public void setjdbcDataSource(Object object) throws Exception {
        if (object instanceof QueryNavigator) {
            this.dataSet = (QueryNavigator)object;
            this.createColumnObjects(this.dataBinding);
            if (this.isRoot) {
                this.getDataModel().getDataTableTree().setRoot(new DataTable((MetaDataModel)this, this.dataSet));
            }
        } else {
            System.out.println("RelationViews not supported");
        }
        this.dataSet.addTriggerUIListener((TriggerUIListener)this);
        this.dataSet.addExceptionEventListener((ExceptionEventListener)this);
    }

    private void setupMediator() {
        if (this.dataSet != null) {
            this.dataSet.removeTriggerUIListener((TriggerUIListener)this);
            this.dataSet.removeExceptionEventListener((ExceptionEventListener)this);
        }
        this.mediator = new Mediator();
        this.mediator.setOutput((Object)this);
        this.mediator.setSetMethods(this.setMethods);
        this.mediator.setGetMethods(this.getMethods);
    }

    public void setDataBinding(String string) {
        if (Beans.isDesignTime()) {
            this.dataBinding = string;
            return;
        }
        this.dataBinding = string;
        this.setupMediator();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@");
        String string2 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        this.mediator.setDataBinding(String.valueOf(string2) + "@CurrentDataSource");
        try {
            Thread.sleep(0L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public String getDataBinding() {
        if (Beans.isDesignTime()) {
            return this.dataBinding;
        }
        return this.mediator.getDataBinding();
    }

    public void handleExceptionEvent(ExceptionEvent exceptionEvent) {
        String string = exceptionEvent.getExceptionName();
        if (string == null || !string.equals("NO ROWS")) {
            this.eventException = new Exception("An exception occurred " + string);
        }
    }

    public void refreshDataSet() throws Exception {
        this.turnOffDataModelEvents();
        this.dataSet.restart();
        this.turnOnDataModelEvents();
    }
}

